function u2=projectP2P2(vertices1,elements1,vertices2,elements2,u1,degree)
%PROJECTP2P2 projection of a P2 function on a grid to a P2 function on another grid
%   U2=PROJECTP2P2(VERTICES1,ELEMENTS1,VERTICES2,ELEMENTS2,U1) project in 
%   the L^2 sense the function P2, defined on the P2 grid VERTICES1, ELEMENTS1
%   in an other P2 grid VERTICES2, ELEMENTS2.
%   U2=PROJECTP2P2(VERTICES1,ELEMENTS1,VERTICES2,ELEMENTS2,U1,DEGREE) in the 
%   computation of the integrals on the new grid uses Dunavant formula of degree
%   DEGREE (the default value is 4).

%       F. Saleri 14-10-03.

if nargin == 5
    degree = 4;
end

% PHI2 the P2 basis functions on the elements IE of the new grid, evaluated
% in the quadrature nodes on the reference element.
[xi,yi,wi,phi2]=basis_on_quad2D('P2',degree);
[n,nq]=size(xi);

[n,noe2] = size(elements2);
[n,noe1] = size(elements1);
[n,nov2] = size(vertices2);
rhs = zeros(1,nov2);
aree = zeros(1,noe1);
massa = sparse(nov2,nov2);

[detjac,dcdx,dcdy,dedx,dedy]=mygeotrasf2D(nov2,vertices2,noe2,elements2);
clear dcdx dcdy dedx dedy
MASSA=matricesP22D;

[bxmin,bymin,bxmax,bymax]=computebbox(vertices1,elements1);
    
for ie = 1:noe2
    i2 = elements2(1:6,ie);
    ax = vertices2(1,i2(1:3));
    ay = vertices2(2,i2(1:3));
    [x,y,weigths]=dunavant(degree,ax,ay);
    v = findnodes(vertices1,elements1,x,y,bxmin,bymin,bxmax,bymax);
    % UHQ is the vector of the values of uh1 in the quadrature nodes on the new grid
    uhq = zeros(1,nq);
    for k = 1:nq
        ie1 = v(k);
        try
            i = elements1(1:6,ie1);
        catch
            ie1
            fprintf('\nErrore in projectP2P2\n');
            keyboard;
        end
        ax = vertices1(1,i(1:3));
        ay = vertices1(2,i(1:3));
        if aree(ie1) == 0
            aree(ie1) = (-ax(2)*ay(3)+ax(2)*ay(1)+ax(1)*ay(3)+ax(3)*ay(2)-ax(3)*ay(1)-ax(1)*ay(2));
        end
        Ainv = [-ay(3)+ay(1) ax(3)-ax(1); ay(2)-ay(1)  -ax(2)+ax(1)]/aree(ie1);
        x_loc = Ainv*[x(k)-ax(1);y(k)-ay(1)];
        xi = x_loc(1);
        yi = x_loc(2);
        phi(1,k) = (1-xi-yi)*(1-2*xi-2*yi);
        phi(2,k) = xi*(-1+2*xi);
        phi(3,k) = yi*(-1+2*yi);
        phi(4,k) = 4*xi*(1-xi-yi);
        phi(5,k) = 4*xi*yi;
        phi(6,k) = 4*yi*(1-xi-yi);
        u_ie1 = u1(i);
        uhq(k) = weigths(k)*phi(:,k)'*u_ie1;
    end
    for l = 1:6
        rhs(i2(l)) = rhs(i2(l)) + uhq*phi2(l,:)';
    end    
    massa(i2,i2) = massa(i2,i2) + MASSA*detjac(ie);
end

u2 = massa\rhs';

return